\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{stc}[2016/03/27 v1.0 Jiri Moravec' Modified article class for STC]

\LoadClass{article}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\usepackage{titlesec}
\usepackage{graphicx}
\usepackage{array,booktabs}
\usepackage{amsmath}
\usepackage{authblk}
\usepackage{multicol}
\usepackage{etoolbox}
\usepackage{fancyhdr}
\usepackage{calc}
\usepackage{float}
\usepackage[labelsep=period]{caption}
\usepackage{quoting}



% PAGE SETTINGS

% set paper and margins
\RequirePackage[a4paper,left=2cm,right=2cm,top=2.5cm,bottom=2cm]{geometry}
\pagestyle{fancy}

% set distance between columns in two-column mode
\setlength{\columnsep}{8mm}

% set skip sizes
\smallskipamount=1mm plus 0.2mm minus 0.2mm
\medskipamount=3mm plus 0.5mm minus 0.5mm
\bigskipamount=6mm plus 1mm minus 1mm

% set header
\fancyhf{}
\renewcommand{\headrulewidth}{0pt}
% For CZECH paper
\chead{Studentská tvůrčí činnost \the\year\ | České vysoké učení technické v Praze | Fakulta strojní}
% For ENGLISH paper
% \chead{Student's Conference \the\year\ | Czech Technical University in Prague | Faculty of Mechanical Engineering}

% header and footer of the first page (email contact in the footer)
\setlength{\footskip}{6mm}
\renewcommand{\footruleskip}{1mm}
\fancypagestyle{plain}{%
  \renewcommand{\footrulewidth}{0.25mm}%
  \renewcommand\footrule{\makebox{\rule{50mm}{\footrulewidth}}\vskip-\footrulewidth}%
  \fancyhf{}%
% Pro ČESKÝ článek:
  \lfoot{\small$^\ast$Kontakt na autora: \@emailcontact}
% For ENGLISH paper:
%   \lfoot{\small$^\ast$Corresponding author: \@emailcontact}
}

% Set margins for quoting (abstract and keywords)
\quotingsetup{vskip=0mm, leftmargin=1mm, rightmargin=1mm}



% TITLE 

% set title font
\patchcmd{\@maketitle}{\LARGE \@title}{\fontsize{14}{14}\fontfamily{phv}\bfseries\selectfont\@title}{}{}



% AUTHORS

% Redefinition of author and affiliation (in authblk package)
\setlength{\affilsep}{.1ex}
\renewcommand\Authfont{\fontsize{10}{10}\fontfamily{phv}\selectfont}
\renewcommand\Affilfont{\fontsize{8}{8}\fontfamily{phv}\itshape\selectfont}
\renewcommand\Authand{, }
\renewcommand\Authands{, }
\renewcommand\AB@authnote[1]{\textsuperscript{\fontfamily{phv}#1}}
\renewcommand\AB@affilnote[1]{\textsuperscript{\fontfamily{phv}#1}}
\date{}

% New commands for marking the presenting author and his/her email address 
\newcommand{\presentingauthor}{\protect\footnotemark}
\newcommand{\@emailcontact}{}
\newcommand{\emailcontact}[1]{\renewcommand{\@emailcontact}{#1}}



% ABSTRACT
\newcommand{\@AbstractName}{}
\newcommand{\AbstractName}[1]{\renewcommand{\@AbstractName}{#1}}
\renewenvironment{abstract}[1]{\noindent\hrule\smallskip\smallskip%
    \begin{quoting}%
    \fontsize{10pt}{10pt}\selectfont%
    \noindent\textbf{\@AbstractName}\par\smallskip\smallskip%
    \fontsize{9pt}{9pt}\selectfont \noindent #1 \medskip%
    \end{quoting}
}



% KEYWORDS
\newcommand{\@KeywordsName}{}
\newcommand{\KeywordsName}[1]{\renewcommand{\@KeywordsName}{#1}}
\newenvironment{keywords}[1]{%
    \begin{quoting}%
    \fontsize{9pt}{9pt}\selectfont%
    \noindent \textit{\@KeywordsName:}~#1%
    \end{quoting}%
    \smallskip\smallskip\hrule\smallskip\smallskip 
}

 
 
% SECTIONS

% arabic numbering for sections, subsections and subsubsections
\renewcommand{\thesection}{\arabic{section}.}
\renewcommand{\thesubsection}{\thesection\arabic{subsection}.}
\renewcommand{\thesubsubsection}{\thesubsection\arabic{subsubsection}.}

% Set lower distance between number and title
\renewcommand{\@seccntformat}[1]{\csname the#1\endcsname\ }

% define section and section name styles
\renewcommand{\section}{%
    \fontsize{10pt}{10pt}\rmfamily\selectfont%
    \@startsection
    {section}{1}{0pt}{-6mm plus -.5mm minus -.5mm}%
    {3mm plus .5mm}{\fontsize{12pt}{12pt}\fontfamily{phv}\bfseries}%
}

% define subsection and subsection name styles
\renewcommand{\subsection}{%
    \fontsize{10pt}{10pt}\rmfamily\selectfont%
    \@startsection
    {subsection}{2}{0pt}{-6mm plus -.5mm minus -.5mm}%
    {3mm plus .5mm}{\fontsize{10pt}{10pt}\fontfamily{phv}\bfseries}%
}

% define subsubsection and subsubsection name styles
\renewcommand{\subsubsection}{%
    \fontsize{10pt}{10pt}\rmfamily\selectfont%
    \@startsection
    {subsubsection}{3}{0pt}{-6mm plus -.5mm minus -.5mm}%
    {3mm plus .5mm}{\fontsize{10pt}{10pt}\fontfamily{phv}\itshape}%
}



% TABLES
% new centering column with fixed width 
\newcolumntype{C}[1]{>{\centering\arraybackslash\hspace{0pt}}p{#1}}



% CAPTIONS
% set caption label and text font
\renewcommand{\captiontextfont}{\fontsize{9pt}{9pt}\rmfamily\itshape\selectfont}
\renewcommand{\captionlabelfont}{\fontsize{9pt}{9pt}\rmfamily\bfseries\itshape\selectfont}

% set left alignment for table caption
\captionsetup[table]{justification=justified, singlelinecheck=false}

 
 
% NOMENCLATURE

% nomenclature lengths
% - the \symL is the width of parbox for the symbol itself
% - the \symT is the width of parbox for the text and unit (derived from \symL and \textwidth)
\newlength{\symL} \setlength{\symL}{1.5em}
\newlength{\symT} \setlength{\symT}{.5\textwidth-\symL-\columnsep}

% nomenclature environment
\newcommand{\@NomenclatureName}{}
\newcommand{\NomenclatureName}[1]{\renewcommand{\@NomenclatureName}{#1}}
\newenvironment{nomenclature}{\bigskip%
    \fontsize{12pt}{12pt}\fontfamily{phv}\bfseries\selectfont%
    \noindent \textbf{\@NomenclatureName}% 
    \fontsize{10pt}{10pt}\normalfont\selectfont \medskip\\
}

% nomenclature items
\newcommand{\nitem}[3]{\ensuremath{#1} \> \parbox[t]{\symT}{#2 \, \ensuremath{(\mathrm{#3})}} \\ }



% ACKNOWLEDGEMENT
% Acknowledgement environment
\newcommand{\@AcknowledgementName}{}
\newcommand{\AcknowledgementName}[1]{\renewcommand{\@AcknowledgementName}{#1}}
\newenvironment{acknowledgement}{\bigskip%
    \fontsize{12pt}{12pt}\fontfamily{phv}\bfseries\selectfont%
    \noindent \textbf{\@AcknowledgementName}% 
    \fontsize{10pt}{10pt}\normalfont\selectfont \medskip\\
}
 